package gov.va.med.mhv.bluebutton.transfer;


import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import javax.xml.datatype.XMLGregorianCalendar;

public class HealthSummaryDTO implements Serializable {
	
	private static final long serialVersionUID = 7097535349012528236L;
	
	String fileContents;
	String fileName;
	String requestDate;
	String status;
	String dateGeneratedTs;
	
	public String getFileContents() {
		return fileContents;
	}

	public void setFileContents(String fileContents) {
		this.fileContents = fileContents;
	}

	public String getRequestDate() {
		return requestDate;
	}

	public void setRequestDate(String requestDate) {
		this.requestDate = requestDate;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}
	
	public String getFilename() {
		return fileName;
	}
	
	public void setFilename(String filename) {
		this.fileName = filename;
	}
	
	public static final String NEW = "NEW";
	public static final String PROCESSING = "PROCESSING";
	public static final String COMPLETED = "COMPLETE";
	public static final String ERROR = "ERROR";
	
	
	public String getDisplayRequestDate(XMLGregorianCalendar dateGenerated) {
		String displayDownloadValue ="";
		if(dateGenerated != null) {
			SimpleDateFormat formatter = new SimpleDateFormat("dd MMM yyyy '@' HHmm");
			displayDownloadValue = formatter.format(dateGenerated.toGregorianCalendar().getTime());
			return displayDownloadValue;
		}
		else
			return "";
	}
	public String getDisplayFileName(XMLGregorianCalendar dateGenerated, String currentUserLastName) {
		String displayDownloadValue ="";
		if(dateGenerated != null) {
			SimpleDateFormat formatter = new SimpleDateFormat("'_'yyyyMMdd'_'HHmm");
			displayDownloadValue = "mhv_VA_CCD_"+currentUserLastName+formatter.format(dateGenerated.toGregorianCalendar().getTime());
			
			return displayDownloadValue;
		}
		else
			return "";
	}
//	public String getRequestDate() {
//		String displayDownloadValue ="";
//		DocStatus reports = (DocStatus) this.getCurrentRowObject();
//		Calendar dateGenerated = Calendar.getInstance();
//		Date requestDate = null;
//		dateGenerated = reports.getDateGenerated();
//		if(dateGenerated!=null)
//			requestDate = reports.getDateGenerated().getTime();
//		if(requestDate != null) {
//			DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
//			displayDownloadValue = formatter.format(requestDate);
//			return displayDownloadValue;
//		}
//		else
//			return "";
//	}
	public String getShowStatus(String status) {
		String displayValue ="";
		if(COMPLETED.equals(status)) {
			displayValue = "Ready to Download";
		}
		else if (ERROR.equals(status)) {
			displayValue = "Error";
		}
		else{
			displayValue = "Request being processed";
		}
		return displayValue;
		
	}
	public String getDownloadStatus(String status) {
		String displayValue ="";
		if(COMPLETED.equals(status)) 
			displayValue = "Download";
		else 
			displayValue = "Refresh";
		
		return displayValue;
	}

	public String getDateGeneratedTs() {
		return dateGeneratedTs;
	}

	public void setDateGeneratedTs(String dateGeneratedTs) {
		this.dateGeneratedTs = dateGeneratedTs;
	}
	
	
//	public String getPatientId() {
//		String displayValue;
//		DocStatus reports = (DocStatus) this.getCurrentRowObject();
//		displayValue = reports.getPatientId();
//		return displayValue;
//		
//	}
	
}
